function [A, NT, fusion_times_cell, RRP,states] = StochasticSytSimulation_DNmutant(Calcium, par_int, nVes, varRRP, DN_IO, n_rep, trackstatesIO)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



%This function computed fusion times simulated at different caclium concentration by using
%stochastic simulations using a Gillespy algorithm

%Input:
%Calcium - Set of calcium concentrations at which the model is evaluated
%par_int - used model parameters
%nVes - average number of vesicles for simulation
%varRRP - 0 for not variable RRP, two values (mean +sd) for generating RRP
%distribution following gamma distributiuon or an array of RRP sizes. 
%DN_IO - 0 for not evaluating mutants, array with 4 values for evaluating
%mutants [fold change KDpip, Fold change KD ca, fold change konCa, A]
%n_rep - number of stochastic repetitions
%trackstates - whether or not to evaluate the state of the system

%Output:
%A - results matrix
%NT_average - Average sampled fusion times
%FusionTimes_cell - Fusion times of all vesicles 
%RRP - Size of the RRP for each repetition
%States - StatesofSyts

Ca0 = 0.05; %resting Ca concentration

if varRRP
    nVes = 15000;
    RRP_max = 15000; 
else
    RRP_max = nVes;
end
nsyt = par_int(8);


%Determine steady state
[Steady_rest] = steady_state_newmethod_mutant(par_int, Ca0, DN_IO);

%Extract RRP sizes
if length(varRRP) ==2 
    nves_mean = varRRP(1);
    nves_sd = varRRP(2);
    k_gamma = (nves_mean^2)/(nves_sd^2);
    thet_gamma = (nves_sd^2)/nves_mean;
    RRP = round(gamrnd(k_gamma, thet_gamma, 1, n_rep));
elseif length(varRRP) >2
    RRP = varRRP;
else
    RRP = ones(1, n_rep)*nVes;
end    


fusion_times_cell = cell(length(Calcium),1);
sampling_rate=50e3;
time_sample=0:1/sampling_rate:0.5;

tic;
parfor m = 1:length(Calcium)
    %Eval_prop = Eval_ca(m,2);
    fusion_times =zeros(nVes,n_rep);
    states_single = cell(nVes*1e5, n_rep);
    Ca_curr = Calcium(m);
    if Ca_curr<1 %Compute new steady state
        [Steady_ca] = steady_state_newmethod_mutant(par_int, Ca0, DN_IO);
        %evalVes=5;
        %Ca_rest = Ca_curr;
    else
        Steady_ca = Steady_rest;
        %evalVes = 5;
        %Ca_rest = Ca0;
    end
    for nn=1:n_rep
        par_int_temp = par_int;
       % tic
        nVes_round = RRP(nn);
        if Ca_curr<1
            evalVes = 5;
        else
            %evalVes = max(5,ceil(Eval_prop*nVes_round));
            evalVes = 100;
        end
           Steady_round = Steady_ca;
        [Steady] = make_SS_stoch_mut(Steady_round, nVes_round, par_int);

%         if (varSlotIO || varSytIO ) &&DN_IO
%         [fusion_times(:,nn)]=directMethod_SingleSyt_DNmutant(Steady, par_int_temp, Ca_curr, evalVes,RRP_max, 0, syt_var_round, maxcross_var,DN_IO);
%         elseif ~varSlotIO && ~varSytIO && DN_IO
%         [fusion_times(:,nn)]=directMethod_SingleSyt_DNmutant1(Steady, par_int_temp, Ca_curr, evalVes,RRP_max, 0, DN_IO);
%         elseif (varSlotIO || varSytIO) && ~DN_IO
%             [fusion_times(:,nn)]=directMethod_SingleSyt_DNmutant2(Steady, par_int_temp, Ca_curr, evalVes,RRP_max, 0, syt_var_round, maxcross_var);
%         else
            [fusion_times(:,nn), states_single(:,nn)]=directMethod_SingleSyt_DNmutant3(Steady, par_int_temp, Ca_curr, evalVes,RRP_max, 0,trackstatesIO);
        end
        
       % toc
    end
    fusion_times_cell{m} = fusion_times;
    states{m} = states_single;
    %mean_max_release_rate(m)= 1/min(mean(diff(fusion_times),2))/1000;
    A(m,1)=Ca_curr;
    if Ca_curr<1
        evalVes = 5;
        A(m,2)=evalVes/mean(fusion_times(evalVes,:))/1000;
        NT = [];
    else
        for i=1:length(time_sample)
        NT(i,:)=sum(fusion_times<time_sample(i)); %cumulative fusion
        end
        A(m,2)=max(diff(mean(NT,2)))*sampling_rate/1000;
    end
    A(m,3)=mean(fusion_times(5,:));
    A(m,4)=median(fusion_times(5,:));
    A(m,5) = std(fusion_times(5,:));
    A(m,6) = quantile(fusion_times(5,:),0.025);
    A(m,7) = quantile(fusion_times(5,:), 0.975);
    disp(['finished ca: ', num2str(Ca_curr)]) 
    save('20210603_GillespieFirstFiveFusionevents.mat')
end
    A(1,8) = toc;
end
